function [] = replicate_file(varargin)
%Replicate all files in a directory n times
%Synatax:   [] = replicate_file('iter',1,dir_tmp,'c:\...');
%Input:     dir_tmp = the original directory
%           dir_out = the output directory
%           iter = the number of iterations or the number of copies
%           dum = create a dummy nan file or not.  Default = 0, not.
%           chg_name = whether you want the copy to have the same name.
%           Default = 1(change name-will be enforced if iter > 1, or input
%           and output directory are the same).
%Output:    no output at this moment

[iter,dir_tmp,dir_out,dum,chg_name] = parse(varargin);

%lets process the directory
dir_struct = dir(dir_tmp);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
filenames = names(~idx);    %all of the files

%replicate each file n times
for i = 1:size(filenames,2);
    for j = 1:iter
        if dum  %create dummy file
            data_tmp = single(dlmread([dir_tmp,filesep,filenames{i}],',',1,0));    %open the file
            data_tmp = nan(size(data_tmp));
            if chg_name==0      %if only one copy,
                sav2csv(data_tmp,filenames{i},dir_out);     %save the file
            else
                sav2csv(data_tmp,[num2str(j),filenames{i}],dir_out);     %save the file
            end
        else
            if chg_name==0
                copyfile([dir_tmp,filesep,filenames{i}],[dir_out,filesep,filenames{i}]);
            else
                copyfile([dir_tmp,filesep,filenames{i}],[dir_out,filesep,num2str(j),filenames{i}]);
            end
        end
    end
end
%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [iter,dir_tmp,dir_out,dum,chg_name] = parse(input)

iter = 1;
dir_tmp = [];
dir_out = [];
dum = 0;
chg_name = 0;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dir_tmp'
                    dir_tmp = input{1,i+1};
                case 'dir_out'
                    dir_out = input{1,i+1};
                case 'iter'
                    iter = input{1,i+1};
                case 'dum'
                    dum = input{1,i+1};
                case 'chg_name'
                    chg_name = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the files you want to open
if isempty(dir_tmp)
    dir_tmp = uigetdir2('','Directory of files you want to replicate');    %get the directory
end
if isempty(dir_out)
    dir_out = uigetdir2('','Output Directory');    %get the directory
end
%enforce name change
if iter>1||strcmp(dir_tmp,dir_out)  %if more than 1 iteration or not the same directory
    chg_name = 1;
end